/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpDataSocket;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.std.IQDConsole;
import java.io.IOException;
import java.io.InputStream;

public class FtpInputStream
extends InputStream {
    private Ftp m_client;
    protected InputStream m_stream;
    protected FtpDataSocket m_data;

    FtpInputStream() {
    }

    public FtpInputStream(FtpFile ftpFile) throws IOException {
        this.m_client = null;
        this.m_data = new FtpDataSocket(ftpFile.getClient());
        this.m_stream = this.m_data.getInputStream("RETR " + ftpFile, ftpFile.getDataType());
    }

    public FtpInputStream(FtpFile ftpFile, FtpConnect ftpConnect, IQDConsole iQDConsole) throws IOException {
        this.m_client = new Ftp();
        if (this.m_client.connect(ftpConnect)) {
            if (iQDConsole != null) {
                this.m_client.getContext().setConsole(iQDConsole);
            }
        } else {
            throw new IOException("Connect failed.");
        }
        ftpFile = new FtpFile(ftpFile.toString(), this.m_client);
        this.m_data = new FtpDataSocket(ftpFile.getClient());
        this.m_stream = this.m_data.getInputStream("RETR " + ftpFile, ftpFile.getDataType());
    }

    public void close() throws IOException {
        IOException iOException = null;
        while (this.m_stream != null || this.m_data != null || this.m_client != null) {
            try {
                if (this.m_stream != null) {
                    InputStream inputStream = this.m_stream;
                    this.m_stream = null;
                    inputStream.close();
                }
                if (this.m_data != null) {
                    FtpDataSocket ftpDataSocket = this.m_data;
                    this.m_data = null;
                    ftpDataSocket.close();
                }
                if (this.m_client == null) continue;
                Ftp ftp = this.m_client;
                this.m_client = null;
                ftp.disconnect();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public int read() throws IOException {
        return this.m_stream.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.m_stream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_stream.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.m_stream.skip(l);
    }

    public int available() throws IOException {
        return this.m_stream.available();
    }

    public synchronized void mark(int n) {
        this.m_stream.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.m_stream.reset();
    }

    public boolean markSupported() {
        return this.m_stream.markSupported();
    }
}

